// Classic game music emulator interface base class for emulators which use Blip_Buffer
// for sound output.

// Game_Music_Emu 0.4.0
#ifndef CLASSIC_EMU_H
#define CLASSIC_EMU_H

#include "Music_Emu.h"
class Blip_Buffer;
class blip_eq_t;
typedef long blip_time_t;

class Classic_Emu : public Music_Emu {
public:
	Classic_Emu();
	~Classic_Emu();
	void set_buffer( Multi_Buffer* );
	void mute_voices( int );
	void set_equalizer( equalizer_t const& );
protected:
	blargg_err_t set_sample_rate_( long sample_rate );
	virtual blargg_err_t setup_buffer( long clock_rate );
	virtual void set_voice( int index, Blip_Buffer* center,
			Blip_Buffer* left, Blip_Buffer* right ) = 0;
	virtual blip_time_t run( int msec, bool* added_stereo );
	virtual blip_time_t run_clocks( blip_time_t, bool* added_stereo );
	virtual void update_eq( blip_eq_t const& ) = 0;
	void start_track_( int track ); 
	void play_( long, sample_t* );
private:
	Multi_Buffer* buf;
	Multi_Buffer* stereo_buffer;
	long clock_rate;
	unsigned buf_changed_count;
};

inline void Classic_Emu::set_buffer( Multi_Buffer* new_buf )
{
	assert( !buf && new_buf );
	buf = new_buf;
}

#endif
